% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_asm.R
\name{calc_logodds}
\alias{calc_logodds}
\title{Calculate the log odds ratio}
\usage{
calc_logodds(s, eps = 1)
}
\arguments{
\item{s}{A data frame that contains the MM,UU,UM, and MU counts for each CpG
tuple for a particular sample. It is the resulting object of the
\code{read_tuples}.}

\item{eps}{Count added to each of the MM,UU,UM and MU counts to avoid
dividing by zero for example. The default is set to 1.}
}
\value{
The same object is returned with an additional column for the log
  odds ratio.
}
\description{
This function calculates the log odds ratio for a CpG tuple:
\code{(MM*UU)/(UM*MU)}, where 'M' stands for methylated and 'U' for
unmethylated. 'MM' reflects the count for instances the CpG pair is
methylated at both positions. The higher the MM and UU counts for that CpG
pair, the higher the log odds ratio.
}
