% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowJoWorkspace_Methods.R
\name{open_flowjo_xml}
\alias{open_flowjo_xml}
\title{Open/Close a flowJo workspace}
\usage{
open_flowjo_xml(file, options = 0, sample_names_from = "keyword", ...)
}
\arguments{
\item{file}{Full path to the XML flowJo workspace file.}

\item{options}{xml parsing options passed to \code{\link{xmlTreeParse}}. See http://xmlsoft.org/html/libxml-parser.html#xmlParserOption for details.}

\item{sample_names_from}{character specifying where in the XML workspace file to obtain the sample names, either
"keyword" for the included $FIL keyword for each sample, or "sampleNode" for the name of the sample node}

\item{...}{not used}
}
\value{
a \code{flowjo_workspace} object.
}
\description{
Open a flowJo workspace and return a \code{flowjo_workspace} object.
Close a flowjo_workspace, destroying the internal representation of the XML document, and freeing the associated memory.
}
\details{
Open an XML flowJo workspace file and return a \code{flowjo_workspace} object. The workspace is represented using a \code{XMLInternalDocument} object.
	Close a flowJoWorkpsace after finishing with it. This is necessary to explicitly clean up the C-based representation of the XML tree. (See the XML package).
}
\examples{
\dontrun{
	file<-"myworkspace.xml"
	ws<-open_flowjo_xml(file);
	ws
}

}
