% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cytobank2GatingSet.R
\name{gs_compare_cytobank_counts}
\alias{gs_compare_cytobank_counts}
\title{compare the counts to cytobank's exported csv so that the parsing result can be verified.}
\usage{
gs_compare_cytobank_counts(
  gs,
  file,
  id.vars = c("FCS Filename", "population"),
  ...
)
}
\arguments{
\item{gs}{parsed GatingSet}

\item{file}{the stats file (contains the populatio counts) exported from cytobank.}

\item{id.vars}{either "population" or "FCS filename" that tells whether the stats file format is one population per row or FCS file per row.}

\item{...}{arguments passed to data.table::fread function}
}
\value{
a data.table (in long format) that contains the counts from openCyto and Cytobank side by side.
}
\description{
compare the counts to cytobank's exported csv so that the parsing result can be verified.
}
\examples{

acsfile <- system.file("extdata/cytobank_experiment.acs", package = "CytoML")
ce <- open_cytobank_experiment(acsfile)
gs <- cytobank_to_gatingset(ce)
## verify the stats are correct
statsfile <- ce$attachments[1]
dt_merged <- gs_compare_cytobank_counts(gs, statsfile, id.vars = "population", skip = "FCS Filename")
all.equal(dt_merged[, count.x], dt_merged[, count.y], tol = 5e-4)

}
