% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowJoWorkspace_Methods.R
\name{fj_ws_get_keywords}
\alias{fj_ws_get_keywords}
\alias{getKeywords}
\title{Get Keywords}
\usage{
fj_ws_get_keywords(obj, y, ...)
}
\arguments{
\item{obj}{A \code{flowjo_workspace}}

\item{y}{c\code{character} or \code{numeric} specifying the sample name or sample ID}

\item{...}{other arguments
sampNloc a \code{character} the location where the sample name is specified. See \code{parseWorkspace} for more details.}
}
\value{
A list of keyword - value pairs.
}
\description{
Retrieve keywords associated with a workspace
}
\details{
Retrieve a list of keywords from a \code{flowjo_workspace}
}
\examples{

\dontrun{
  d<-system.file("extdata",package="flowWorkspaceData")
  wsfile<-list.files(d,pattern="manual.xml",full=TRUE)
  ws <- open_flowjo_xml(wsfile)

  fj_ws_get_samples(ws)
  res <- try(fj_ws_get_keywords(ws,"CytoTrol_CytoTrol_1.fcs"), silent = TRUE)
  print(res[[1]])
  fj_ws_get_keywords(ws, 1)
}
}
