% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{channelSummaryStats}
\alias{channelSummaryStats}
\title{Summary statistics per channel computation}
\usage{
channelSummaryStats(
  x,
  loadExprMatrixFUN = NULL,
  loadExprMatrixFUNArgs = NULL,
  channels = NULL,
  statFUNs = stats::median,
  verbose = FALSE,
  BPPARAM = BiocParallel::SerialParam(),
  BPOPTIONS = BiocParallel::bpoptions(packages = c("flowCore"))
)
}
\arguments{
\item{x}{can be:
\itemize{
\item a flowCore::flowSet
\item a list of expression matrices (Double matrix with named columns)
\item the number of samples (integer >=1)
}}

\item{loadExprMatrixFUN}{the function used to translate an integer index
into an expression matrix. In other words, the function should code how to
load the \code{index}th expression matrix into memory.
IMPORTANT: the expression matrix index should be the first function argument
and should be named \code{exprMatrixIndex}.}

\item{loadExprMatrixFUNArgs}{(optional) a named list containing
additional input parameters of \code{loadExprMatrixFUN()}}

\item{channels}{which channels needs to be included:
\itemize{
\item if it is a character vector,
it can refer to either the channel names, or the marker names
\item if it is a numeric vector,
it refers to the indices of channels in \code{fs}
\item if NULL, all scatter and fluorescent channels of \code{fs} #' will be selected.
}}

\item{statFUNs}{a list (possibly of length one) of functions to call
to calculate the statistics, or a simple function.
This list can be named, in that case, these names will be transfered to the
returned list.}

\item{verbose}{if \code{TRUE}, output a message
after each single statistics calculation}

\item{BPPARAM}{sets the \code{BPPARAM} back-end to
be used for the computation. If not provided, will use
\code{BiocParallel::SerialParam()} (no task parallelization)}

\item{BPOPTIONS}{sets the BPOPTIONS to be passed to \code{bplapply()} function.
Note that if you use a \code{SnowParams} back-end, you need to specify all
the packages that need to be loaded for the different CytoProcessingStep
to work properly (visibility of functions). As a minimum,
the \code{flowCore} package needs to be loaded.
(hence the default \code{BPOPTIONS = bpoptions(packages = c("flowCore"))} )}
}
\value{
a list of named statistic matrices.
In each stat matrix, the columns are the channel statistics
for all flowFrames of the flowSet.
Exception: if only one stat function (and not a list) is passed in
\code{statFUNs}, the return value is simplified to the stat matrix itself.
}
\description{
Computation of summary statistic for selected channels,
for all flowFrames of a flowSet, or for all expression matrices of a list.
This method provides three different input modes:
\itemize{
\item the user provides directly a flowCore::flowSet loaded in memory (RAM)
\item the user provides directly a list of expression matrices of which the
column names are the channel/marker names
\item the user provides (1.) a number of samples \code{nSamples}; (2.) an ad-hoc
function that takes as input an index between 1 and \code{nSamples}, and codes
the method to load the corresponding expression matrix in memory;
}
}
\examples{

library(CytoPipeline)

data(OMIP021Samples)

# estimate scale transformations 
# and transform the whole OMIP021Samples

transList <- estimateScaleTransforms(
    ff = OMIP021Samples[[1]],
    fluoMethod = "estimateLogicle",
    scatterMethod = "linearQuantile",
    scatterRefMarker = "BV785 - CD3")

OMIP021Trans <- CytoPipeline::applyScaleTransforms(
    OMIP021Samples, 
    transList)

channelsOrMarkers <- c("FSC-A", "SSC-A", "BV785 - CD3")

# calculate mean for each 4 selected channels, for each 2 samples

channelMeans <- channelSummaryStats(
    OMIP021Trans,
    channels = channelsOrMarkers,
    statFUNs = mean)
    
# calculate median AND std deviation
# for each 4 selected channels, for each 2 samples

channelMedians <- channelSummaryStats(
    OMIP021Trans,
    channels = channelsOrMarkers,
    statFUNs = list("median" = stats::median, 
                    "std.dev" = stats::sd))
 
}
