% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MDS-class.R
\docType{class}
\name{MDS-class}
\alias{MDS-class}
\alias{show,MDS-method}
\alias{nDim}
\alias{nPoints}
\alias{pwDist}
\alias{projections}
\alias{projDist}
\alias{stress}
\alias{spp}
\alias{eigenVals}
\alias{pctvar}
\alias{RSq}
\alias{RSqVec}
\alias{GoF}
\alias{smacofRes}
\title{MDS class}
\usage{
\S4method{show}{MDS}(object)

nDim(x)

nPoints(x)

pwDist(x)

projections(x)

projDist(x)

stress(x)

spp(x)

eigenVals(x)

pctvar(x)

RSq(x)

RSqVec(x)

GoF(x)

smacofRes(x)
}
\arguments{
\item{object}{a \code{MDS} object}

\item{x}{a \code{MDS} object}
}
\value{
nothing
}
\description{
Class representing Multi Dimensional Scaling (MDS) projection.

returns the value of the stress criterion, minimized by the
SMACOF algorithm.

returns a vector of nPoints dimension, containing the stress
indicator per point. The \code{stress} minimization criterion can indeed be
allocated per represented point. The more the stress of a particular point,
the less accurate its distances w.r.t. the other points.
}
\section{Slots}{

\describe{
\item{\code{nDim}}{\code{numeric}, nb of dimensions of the projection}

\item{\code{pwDist}}{An object of class \code{dist} storing
the triangular relevant part of the symmetric, zero diagonal
pairwise distance matrix (nPoints * nPoints), BEFORE projection.}

\item{\code{proj}}{The projection matrix, resulting from MDS}

\item{\code{projDist}}{An object of class \code{dist} storing
the triangular relevant part of the symmetric, zero diagonal
pairwise distance matrix (nPoints * nPoints), AFTER projection.}

\item{\code{eigen}}{\code{numeric}, vector of \code{nDim} length, containing the eigen
values of the PCA that is applied after the Smacof algorithm.}

\item{\code{pctvar}}{\code{numeric}, vector of \code{nDim} length, containing the percentage
of explained variance per axis.}

\item{\code{RSq}}{\code{numeric}, vector of pseudo R square indicators,
as a function of number of dimensions.
\code{RSq[nDim]} is the global pseudo R square, as displayed on plots.}

\item{\code{GoF}}{\code{numeric}, vector of goodness of fit indicators,
as a function of number of dimensions.
\code{GoF[nDim]} is the global goodness of fit.

Note pseudo R square and goodness of fit indicators are essentially the
same indicator, only the definition of total sum of squares differ:
\itemize{
\item for pseudo RSq: TSS is calculated using the mean pairwise distance
as minimum
\item for goodness of fit: TSS is calculated using 0 as minimum
}}

\item{\code{smacofRes}}{an object of class 'smacofB' containing the algorithmic
optimization results, for example stress and stress per point,
as returned by \code{smacof::smacofSym()} method.}
}}

\examples{


nHD <- 10
nLD <- 2
nPoints <- 20 

# generate uniformly distributed points in 10 dimensions
points <- matrix(
    data = runif(n = nPoints * nHD),
    nrow = nPoints)
    
# calculate euclidian distances     
pwDist  <- dist(points)

# compute Metric MDS object by reaching a target pseudo RSquare
mdsObj <- computeMetricMDS(pwDist, targetPseudoRSq = 0.95)

show(mdsObj)


}
