% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alleleLabels.R
\name{.formatVarLabels}
\alias{.formatVarLabels}
\alias{.findMismatches}
\title{formatVarLabels}
\usage{
.formatVarLabels(
  grl,
  labels,
  position = c("start", "end"),
  genome.to.pos = NULL,
  pos.to.lab = ":",
  as.string = TRUE
)

.findMismatches(
  alns,
  ref.seq,
  ref.start,
  regions = NULL,
  strand = "+",
  min.pct = 0
)
}
\arguments{
\item{grl}{(GRangesList) A GRangesList of variants.  The position
of the variants is used in labels}

\item{labels}{(character(n)) A vector of labels for each variant.
In CrispRVariants, this is the size and type of the variant, e.g. "9D"
for a 9 bp deletion.}

\item{position}{One of "start" and "end".  Determines whether the
start or the end coordinate is used when labeling variants.}

\item{genome.to.pos}{Optional named vector for transforming 
variant coordinates into another coordinate system (Default: NULL)}

\item{pos.to.lab}{(character(1)) Character to join positions and labels
(Default: ":", e.g. -3:9D)}

\item{as.string}{Should individual variant labels be pasted into
a single comma separated string when one alignment has multiple variants?
(Default: TRUE)}

\item{alns}{A GAlignments object, where the aligned sequences should span the
reference sequence}

\item{ref.seq}{A DNAString object, the sequence for comparison when checking
for mismatches.  The sequence does not necessarily have to match the mapping
reference sequence.  Must span all regions if regions are provided.}

\item{ref.start}{(numeric(1)) The genomic start position of the reference sequence}

\item{regions}{A GRanges object, regions to check for mismatches with coordinates
relative to the reference sequence}

\item{strand}{One of "+", "-"}

\item{min.pct}{(numeric(1), between 0 and 100) Only return SNVs that occur
at in least min.pct % of reads.  This tests the occurrence of the exact base
change, not any change at a position.}
}
\value{
A data frame of sequence indices, genomic position of mismatch
and mismatch base
}
\description{
Internal CrispRVariants function for creating allele
labels given variants and positions

Assume that the reference may be on the negative strand and
regions are given with respect to the reference sequence.
}
