\name{write.profile}
\alias{write.profile}
\alias{write.profile,matrix-method}
\title{Write coverage values into a file}
\description{Write the coverage values calculated using the \code{cov.matrix} function into a file}
\usage{
\S4method{write.profile}{matrix}(DF,outfile=NULL)
}
\arguments{
  \item{DF}{Coverage matrix generated by the function \code{cov.matrix}}
  \item{outfile}{Where to write the \code{.txt} file that will contain the matrix}
}
\details{
This method is used to write the matrix containing the coverage values calculated by \code{cov.matrix} into a file. 
}
\author{
Ernesto Lowy <ernestolowy@gmail.com>
}
\seealso{
\code{\link{cov.matrix}}
}
\examples{
#get a BAM test file
treatBAMfile<-system.file("extdata","treat.bam",package="CoverageView")
  
#get a BED file with the TSS (transcription start site) coordinates of some genes
bedfile<-system.file("extdata","testTSS.bed",package="CoverageView")
  
#create the CoverageBamFile object
trm<-CoverageBamFile(treatBAMfile)
  
#generate the coverage matrix extending 100 nts on each side of the TSS provided
#in the BED file
DF1=cov.matrix(trm,coordfile=bedfile,extend=100)
  
#write the coverage matrix into the provided file
write.profile(DF1,outfile="DF1.txt")
}
