% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LongTable-utils.R
\name{reindex,LongTable-method}
\alias{reindex,LongTable-method}
\title{Redo indexing for a LongTable object to remove any gaps in integer indexes}
\usage{
\S4method{reindex}{LongTable}(object)
}
\arguments{
\item{object}{The \code{LongTable} object to recalcualte indexes (rowKey and
colKey values) for.}
}
\value{
A copy of the \code{LongTable} with all keys as the smallest set of
contiguous integers possible given the current data.
}
\description{
After subsetting a LongTable, it is possible that values of rowKey or colKey
could no longer be present in the object. As a result there the indexes
will no longer be contiguous integers. This method will calcualte a new
set of rowKey and colKey values such that integer indexes are the smallest
set of contiguous integers possible for the data.
}
