% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizeCoreGx.R
\name{optimizeCoreGx}
\alias{optimizeCoreGx}
\title{A helper method to find the best multithreading configuration for your
computer}
\usage{
optimizeCoreGx(sample_data, set = FALSE, report = !set)
}
\arguments{
\item{sample_data}{\code{TreatmentResponseExperiment}}

\item{set}{\code{logical(1)} Should the function modify your R environment
with the predicted optimal settings? This changes the global state of your
R session!}

\item{report}{\code{logical(1)} Should a \code{data.frame} of results be returned
by number of threads and operation be returned? Defaults to \code{!set}.}
}
\value{
If \code{set=TRUE}, modifies \code{data.table} threads via \code{setDTthreads()}, otherwise
displays a message indicating the optimal number of threads.
If \code{report=TRUE}, also returns a \code{data.frame} of the benchmark results.
}
\description{
A helper method to find the best multithreading configuration for your
computer
}
\examples{
\donttest{
  data(merckLongTable)
  optimizeCoreGx(merckLongTable)
}

}
