% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/immutable-class.R
\docType{class}
\name{immutable}
\alias{immutable}
\alias{immutable_list-class}
\alias{is.immutable}
\alias{print.immutable}
\alias{show.immutable}
\title{Constructor for "immutable" S3-class property}
\usage{
immutable(object)

is.immutable(object)

\method{print}{immutable}(x, ...)

show.immutable(x)
}
\arguments{
\item{object, x}{Any R object which uses S3 method dispatch}

\item{...}{Fallthrough arguments to \code{print.default}.}
}
\value{
The \code{object} with "immutable" prepended to its class attribute.

\code{logical(1)} Does the object inherit from the "immutable" S3-class?

None, \code{invisible(NULL)}
}
\description{
This method should allow any S3 object in R to become immutable by
intercepting \verb{[<-}, \verb{[[<-}, \verb{$<-} and \code{c} during S3-method dispatch and
returning an error.

Reverse with call to the \code{mutable} function.
}
\details{
The motivation for this class was to create pseudo-private slots in an R
S4 object by preventing mutation of those slots outside of the accessors
written for the class. It should behave as expected for R object which
operate with 'copy-on-modify' semantics, including most base R functions and
S3 objects.

An environment was not suitable for this case due
to the 'copy-by-reference' semantics, such that normal R assignment, which
users assume makes a copy of the object, actually references the same
environment in both the original and copy of the object.

WARNING: This implementation is unable to intercept modifications to a
\code{data.table} via the \verb{set*} group of methods. This is because these methods
are not S3 generics and therefore no mechanism exists for hooking into them
to extend their functionality. In general, this helper class will only work
for objects with an S3 interface.
}
\examples{
immutable_list <- immutable(as.list(1:5))
class(immutable_list)
# errors during assignment operations
tryCatch({ immutable_list$new <- 1 }, error=print)

immutable_list <- immutable(as.list(1:5))
is.immutable(immutable_list)

}
\seealso{
\code{\link{assignment-immutable}}, \code{\link{setOps-immutable}}
}
