% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-optimization.R
\name{.fitCurve2}
\alias{.fitCurve2}
\title{Curve fitting via \code{stats::optim} L-BFGS-B with fall-back grid/pattern search
if convergence is not achieved.}
\usage{
.fitCurve2(
  par,
  x,
  y,
  fn,
  loss,
  lower = -Inf,
  upper = Inf,
  precision = 1e-04,
  density = c(2, 10, 5),
  step = 0.5/density,
  ...,
  loss_args = list(),
  span = 1,
  optim_only = FALSE,
  control = list(factr = 1e-08, ndeps = rep(1e-04, times = length(par)), trace = 0)
)
}
\arguments{
\item{par}{\code{numeric} Vector of intial guesses for the parameters. For each
index \code{i} of \code{par}, par[i] must be within the range (\verb{lower\[i\]},
\verb{upper\[i\]}). If only a single \code{upper} or \code{lower} value is present,
that range is used for all parameters in \code{par}.}

\item{x}{\code{numeric} Values to evaluate \code{fn} for.}

\item{y}{\code{numeric} Target output values to optimze \code{fn} against.}

\item{fn}{\code{function} A function to optimize. Any \code{fn} arguments passed via
\code{...} will be treated as constant and removed from the optimization. It
is assumed that the first argument is the x value to optimize over and
any subsequent arguments are free parameters to be optimized. Transformed
to be optim compatible via \code{make_optim_function} is the first arguement
isn't already \code{par}.}

\item{loss}{\code{character(1)} or \code{function} Either the name of one of the bundled
loss functions (see details) or a custom loss function to compute for
the output of \code{fn} over \code{x}.}

\item{lower}{\code{numeric(1)} Lower bound for parameters. Parallel to \code{par}.}

\item{upper}{\code{numeric(1)} Upper bound for paramteres. Parallel to \code{par}.}

\item{precision}{\code{numeric} smallest step size used in pattern search, once
step size drops below this value, the search terminates.}

\item{density}{\code{numeric} how many points in the dimension of each parameter
should be evaluated (density of the grid)}

\item{step}{initial step size for pattern search.}

\item{...}{\code{pairlist} Fall through arguments to \code{fn}.}

\item{loss_args}{\code{list} Additional argument to the \code{loss} function.
These get passed to losss via \code{do.call} analagously to using \code{...}.}

\item{span}{\code{numeric} Can be safely kept at 1, multiplicative ratio for
initial step size in pattern search. Must be larger than precision.}

\item{optim_only}{\code{logical(1)} Should the fall back methods when optim fails
be skipped? Default is \code{FALSE}.}

\item{control}{\code{list} List of control parameters to pass to \code{optim}. See
\code{?optim} for details.}
}
\value{
\code{numeric} Vector of optimal parameters for \code{fn} fit against \code{y}
on the values of \code{x}.
}
\description{
Function to fit curve via stats::optim
}
\details{
TODO
}
\examples{
\dontrun{
  # Four parameter hill curve equation
  hillEqn <- function(x, Emin, Emax, EC50, lambda) {
      (Emin + Emax * (x / EC50)^lambda) / (1 + (x / EC50)^lambda)
  }
  # Make some dummy data
  doses <- rev(1000 / (2^(1:20)))
  lambda <- 1
  Emin <- 1
  Emax <- 0.1
  EC50 <- median(doses)
  response <- hillEqn(doses, Emin=Emin, lambda=lambda, Emax=Emax, EC50=EC50)
  nresponse <- response + rnorm(length(response), sd=sd(response)*0.1) # add noise
  # 3-parameter optimization
  3par <- .fitCurve2(
      par=c(Emax, EC50, lambda),
      x=doses,
      y=nresponse,
      fn=hillEqn,
      Emin=Emin, # set this as constant in the function being optimized (via ...)
      loss=.normal_loss,
      loss_args=list(trunc=FALSE, n=1, scale=0.07),
      upper=c(1, max(doses), 6),
      lower=c(0, min(doses), 0)
  )
  # 2-parameter optimization
  2par <- .fitCurve2(
      par=c(Emax, EC50),
      x=doses,
      y=nresponse,
      fn=hillEqn,
      Emin=Emin, # set this as constant in the function being optimized (via ...)
      lambda=1,
      loss=.normal_loss,
      loss_args=list(trunc=FALSE, n=1, scale=0.07),
      upper=c(1, max(doses)),
      lower=c(0, min(doses))
  )
}

}
