% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-coerce.R
\name{.assayToBumpyMatrix}
\alias{.assayToBumpyMatrix}
\title{Convert a LongTable assay into a BumpyMatrix object}
\usage{
.assayToBumpyMatrix(LT, assay, rows, cols, sparse = TRUE)
}
\arguments{
\item{LT}{\code{LongTable} with assay to convert into \code{BumpyMatrix}}

\item{assay}{\code{character(1)} A valid assay name in \code{LT}, as returned by
\code{assayNames(LT)}.}

\item{rows}{\code{character()} The rownames associated with the assay rowKey}

\item{cols}{\code{character()} The names associated with the assay colKey}

\item{sparse}{\code{logical(1)} Should the \code{BumpyMatrix} be sparse (i.e., is the
assay sparse).}
}
\value{
\code{BumpyMatrix} containing the data from \code{assay}.
}
\description{
Convert a LongTable assay into a BumpyMatrix object
}
