% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-optimization.R
\name{collect_fn_params}
\alias{collect_fn_params}
\title{Collects all function arguments other than the first into a single list
parameter.}
\usage{
collect_fn_params(fn)
}
\arguments{
\item{fn}{\code{function} A non-primitive function to refactor such that the first
argument becomes the second argument and all other parameters must be
passed as a vector to the first argument of the new function via the \code{par}
parameter.}
}
\value{
\code{function} A new non-primitive function where the first argument is
\code{par}, which takes a vector of parameters being optimized, and the
second argument is the old first argument to \code{fn} (usually \code{x} since this
is the independent variable to optimize the function over).
}
\description{
Useful for converting a regular function into a function amenable to
optimization via \code{stats::optim}, which requires all free parameters be
passed as a single vector \code{par}.
}
\details{
Takes a function of the form f(x, ...), where ... is any number of additional
function parameters (bot not literal \code{...}!) and parses it to a function of
the form f(par, x) where \code{par} is a vector of values for ... in
the same order as the arguments appear in \code{fn}.
}
