% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreSet-class.R
\name{checkCsetStructure}
\alias{checkCsetStructure}
\title{A function to verify the structure of a CoreSet}
\usage{
checkCsetStructure(object, plotDist = FALSE, result.dir = tempdir())
}
\arguments{
\item{object}{A \code{CoreSet} to be verified}

\item{plotDist}{Should the function also plot the distribution of molecular
data?}

\item{result.dir}{The path to the directory for saving the plots as a string.
Defaults to this R sessions \code{tempdir()}.}
}
\value{
Prints out messages whenever describing the errors found in the
structure of the cSet object passed in.
}
\description{
This function checks the structure of a PharamcoSet, ensuring that the
correct annotations are in place and all the required slots are filled so
that matching of samples and drugs can be properly done across different types
of data and with other studies.
}
\examples{
checkCsetStructure(clevelandSmall_cSet)

}
