% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LongTableDataMapper-class.R
\docType{class}
\name{LongTableDataMapper-class}
\alias{LongTableDataMapper-class}
\alias{.LongTableDataMapper}
\alias{show,LongTableDataMapper-method}
\title{A Class for Mapping Between Raw Data and an \code{LongTable} Object}
\usage{
\S4method{show}{LongTableDataMapper}(object)
}
\arguments{
\item{object}{A \code{LongTableDataMapper} to display in the console.}
}
\value{
\code{invisible} Prints to console.
}
\description{
A Class for Mapping Between Raw Data and an \code{LongTable} Object
}
\section{Functions}{
\itemize{
\item \code{show(LongTableDataMapper)}: Show method for LongTableDataMapper.
Determines how the object is displayed in the console.

}}
\section{Slots}{

\describe{
\item{\code{rawdata}}{See Slots section.}

\item{\code{rowDataMap}}{See Slots section.}

\item{\code{colDataMap}}{See Slots section.}

\item{\code{assayMap}}{See Slots section.}

\item{\code{metadataMap}}{See Slots section.}
}}

\section{Slots}{

\itemize{
\item rowDataMap: A list-like object containing two \code{character} vectors.
The first is column names in \code{rawdata} needed to uniquely identify each row,
the second is additional columns which map to rows, but are not required to
uniquely identify them. Rows should be drugs.
\item colDataMap: A list-like object containing two \code{character} vectors.
The first is column names in \code{rawdata} needed to uniquely identify each
column, the second is additional columns which map to rows, but are not
required to uniquely identify them. Columns should be samples.
\item assayMap A list-like where each item is a \code{list} with two elements
specifying an assay, the first being the identifier columns in \code{rawdata}
needed to uniquely identify each row an assay, and the second a list of
\code{rawdata} columns to be mapped to that assay. The names of \code{assayMap}
will be the names of the assays in the \code{LongTable} that is created when
calling \code{metaConstruct} on this \code{DataMapper} object.
\item metadataMap: A list-like where each item is a \code{character} vector of
\code{rawdata} column names to assign to the \verb{@metadata} of the \code{LongTable},
where the name of that assay is the name of the list item. If names are
omitted, assays will be numbered by their index in the list.
}


\itemize{
\item rawdata: A list-like object containing one or more pieces of raw data
that will be processed and mapped to the slots of an \code{S4} object.
\item metadata: A \code{List} of object level metadata.
}
}

\examples{
show(exampleDataMapper)

}
