% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreMethods.R
\name{PrepareData}
\alias{PrepareData}
\alias{PrepareData.SingleCellExperiment}
\alias{PrepareData,SingleCellExperiment-method}
\title{Prepare \code{SingleCellExperiment} object for analysis}
\usage{
PrepareData.SingleCellExperiment(object)

\S4method{PrepareData}{SingleCellExperiment}(object)
}
\arguments{
\item{object}{An object of \code{SingleCellExperiment} class.}
}
\value{
An object of \code{SingleCellExperiment} class.
}
\description{
This function prepares the \code{SingleCellExperiment} object
for analysis. The only required input is an object of class \code{SingleCellExperiment}
with at least data in the \code{logcounts} slot.
}
\examples{
# Import package
suppressPackageStartupMessages(library("SingleCellExperiment"))

# Create toy SCE data
batches <- c("b1", "b2")
set.seed(239)
batch <- sample(x = batches, size = nrow(iris), replace = TRUE)
sce <- SingleCellExperiment(
    assays = list(logcounts = t(iris[, 1:4])),
    colData = DataFrame(
        "Species" = iris$Species,
        "Batch" = batch
    )
)
colnames(sce) <- paste0("samp", 1:ncol(sce))
sce <- PrepareData(sce)

}
\keyword{clean}
\keyword{data}
\keyword{normalized}
\keyword{prepare}
