% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VizMethods.R
\name{PlotExpression}
\alias{PlotExpression}
\alias{PlotExpression.SingleCellExperiment}
\alias{PlotExpression,SingleCellExperiment-method}
\title{Plot dimensional reduction feature expression}
\usage{
PlotExpression.SingleCellExperiment(
  object,
  color.by,
  dimred,
  scale.values,
  color.scale,
  plot.theme,
  legend.title,
  point.size,
  point.stroke
)

\S4method{PlotExpression}{SingleCellExperiment}(
  object,
  color.by,
  dimred = tail(reducedDimNames(object), n = 1),
  scale.values = FALSE,
  color.scale = "inferno",
  plot.theme = theme_classic(),
  legend.title = color.by,
  point.size = 1,
  point.stroke = 1
)
}
\arguments{
\item{object}{An object of \code{SingleCellExperiment} class.}

\item{color.by}{Categorical variable available in \code{colData(object)} to
plot.}

\item{dimred}{Dimensional reduction available in \code{ReducedDimNames(object)}
to plot. By default the last dimensional reduction in the object is used.}

\item{scale.values}{Logical specifying if values should be scaled. By default
\code{FALSE}, i.e., values are not scaled.}

\item{color.scale}{Character of color scale palette to be passed to
\code{ggplot2::scale_color_viridis_c}. By default \code{inferno}. Other palettes
are also available such as \code{viridis}.}

\item{plot.theme}{Plot theme available in \code{ggplot2}. By default \code{theme_classic()}.}

\item{legend.title}{Legend title. By default the same as given at \code{color.by}.}

\item{point.size}{Size of points. By default \code{1}.}

\item{point.stroke}{Size of stroke. By default \code{1}.}
}
\value{
A plot of class \code{ggplot}.
}
\description{
Plot feature expression in dimensional reduction.
}
\examples{
# Import package
suppressPackageStartupMessages(library("SingleCellExperiment"))

# Create toy SCE data
batches <- c("b1", "b2")
set.seed(239)
batch <- sample(x = batches, size = nrow(iris), replace = TRUE)
sce <- SingleCellExperiment(
    assays = list(logcounts = t(iris[, 1:4])),
    colData = DataFrame(
        "Species" = iris$Species,
        "Batch" = batch
    )
)
colnames(sce) <- paste0("samp", 1:ncol(sce))

# Compute dimensional reduction
sce <- RunPCA(
    object = sce, assay.name = "logcounts", p = 4,
    pca.method = "stats"
)

# Plot expression level of one or more features
## one
PlotExpression(object = sce, color.by = "Petal.Width")

## more than one
features <- row.names(sce)[1:4]
exp.plots <- lapply(X = features, FUN = function(x) {
    PlotExpression(object = sce, color.by = x, scale.values = TRUE)
})
cowplot::plot_grid(plotlist = exp.plots, ncol = 2, align = "vh")

}
\keyword{Dimensional}
\keyword{reduction}
\keyword{visualization}
