% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreMethods.R
\name{GetFeatureCoefficients}
\alias{GetFeatureCoefficients}
\alias{GetFeatureCoefficients.SingleCellExperiment}
\alias{GetFeatureCoefficients,SingleCellExperiment-method}
\title{Get feature coefficients}
\usage{
GetFeatureCoefficients.SingleCellExperiment(
  object,
  icp.run = NULL,
  icp.round = NULL
)

\S4method{GetFeatureCoefficients}{SingleCellExperiment}(object, icp.run = NULL, icp.round = NULL)
}
\arguments{
\item{object}{An object of \code{SingleCellExperiment} class with ICP cell
cluster probability tables saved in \code{metadata(object)$coralysis$joint.probability}.
After running \code{RunParallelDivisiveICP}.}

\item{icp.run}{ICP run(s) to retrieve from \code{metadata(object)$coralysis$joint.probability}.
By default \code{NULL}, i.e., all are retrieved. Specify a numeric vector to
retrieve a specific set of tables.}

\item{icp.round}{ICP round(s) to retrieve from \code{metadata(object)$coralysis$joint.probability}.
By default \code{NULL}, i.e., all are retrieved.}
}
\value{
A list of feature coefficient weights per cluster per ICP run/round.
}
\description{
Get feature coefficients from ICP models.
}
\examples{
# Import package
suppressPackageStartupMessages(library("SingleCellExperiment"))

# Create toy SCE data
batches <- c("b1", "b2")
set.seed(239)
batch <- sample(x = batches, size = nrow(iris), replace = TRUE)
sce <- SingleCellExperiment(
    assays = list(logcounts = t(iris[, 1:4])),
    colData = DataFrame(
        "Species" = iris$Species,
        "Batch" = batch
    )
)
colnames(sce) <- paste0("samp", 1:ncol(sce))

# Prepare SCE object for analysis
sce <- PrepareData(sce)

# Multi-level integration (just for highlighting purposes; use default parameters)
set.seed(123)
sce <- RunParallelDivisiveICP(
    object = sce, batch.label = "Batch",
    k = 4, L = 25, C = 1, d = 0.5,
    train.with.bnn = FALSE,
    use.cluster.seed = FALSE,
    build.train.set = FALSE, ari.cutoff = 0.1,
    threads = 2, RNGseed = 1024
)


# GetFeatureCoefficients
gene_coefficients_icp_7_1 <- GetFeatureCoefficients(object = sce, icp.run = 7, icp.round = 1)
head(gene_coefficients_icp_7_1$icp_13)

}
\keyword{Feature}
\keyword{coefficients}
\keyword{weights}
