% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CellStateMethods.R
\name{BinCellClusterProbability}
\alias{BinCellClusterProbability}
\alias{BinCellClusterProbability.SingleCellExperiment}
\alias{BinCellClusterProbability,SingleCellExperiment-method}
\title{Bin cell cluster probability}
\usage{
BinCellClusterProbability.SingleCellExperiment(
  object,
  label,
  icp.run,
  icp.round,
  funs,
  bins,
  aggregate.bins.by,
  use.assay
)

\S4method{BinCellClusterProbability}{SingleCellExperiment}(
  object,
  label,
  icp.run = NULL,
  icp.round = NULL,
  funs = "mean",
  bins = 20,
  aggregate.bins.by = "mean",
  use.assay = "logcounts"
)
}
\arguments{
\item{object}{An object of \code{SingleCellExperiment} class with ICP cell
cluster probability tables saved in \code{metadata(object)$coralysis$joint.probability}.
After running one of \code{RunParallelICP} or \code{RunParallelDivisiveICP}.}

\item{label}{Label of interest available in \code{colData(object)} to group by the
bins of cell cluster probability.}

\item{icp.run}{ICP run(s) to retrieve from \code{metadata(object)$coralysis$joint.probability}.
By default \code{NULL}, i.e., all are retrieved. Specify a numeric vector to
retrieve a specific set of tables.}

\item{icp.round}{ICP round(s) to retrieve from \code{metadata(object)$coralysis$joint.probability}.
By default \code{NULL}, i.e., all are retrieved. Only relevant if probabilities
were obtained with the function \code{RunParallelDivisiveICP}, i.e., divisive ICP
was performed. Otherwise it is ignored and internally assumed as \code{icp.round = 1},
i.e., only one round.}

\item{funs}{One function to summarise ICP cell cluster probability. One of \code{"mean"}
or \code{"median"}. By default \code{"mean"}.}

\item{bins}{Number of bins to bin cell cluster probability by cell \code{label} given.
By default \code{20}.}

\item{aggregate.bins.by}{One function to aggregate One of \code{"mean"} or
\code{"median"}. By default \code{"mean"}.}

\item{use.assay}{Name of the assay that should be used to obtain the average expression
of features across cell \code{label} probability bins.}
}
\value{
A \code{SingleCellExperiment} class object with feature average expression by
cell \code{label} probability bins.
}
\description{
Bin cell cluster probability by a given cell label.
}
\examples{
\donttest{
# Packages
suppressPackageStartupMessages(library("SingleCellExperiment"))

# Import data from Zenodo
data.url <- "https://zenodo.org/records/14845751/files/pbmc_10Xassays.rds?download=1"
sce <- readRDS(file = url(data.url))

# Prepare data
sce <- PrepareData(object = sce)

# Multi-level integration - 'L = 4' just for highlighting purposes
set.seed(123)
sce <- RunParallelDivisiveICP(
    object = sce, batch.label = "batch", L = 4,
    threads = 2
)

# Cell states SCE object for a given cell type annotation or clustering
cellstate.sce <- BinCellClusterProbability(
    object = sce, label = "cell_type",
    icp.round = 4, bins = 20
)
cellstate.sce
}

}
\keyword{Bin}
\keyword{cell}
\keyword{cluster}
\keyword{probability}
