% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplifyProteins.R
\name{simplifyProteins}
\alias{simplifyProteins}
\title{Simplify Raw Proteins file}
\usage{
simplifyProteins(.data, direction = c("rows", "cols"))
}
\arguments{
\item{.data}{a dataframe}

\item{direction}{character, rows, cols or both}
}
\value{
a dataframe
}
\description{
\itemize{
\item For rows: Keep only one row with highest Precursor Area in cases where
for a single Protein Group Accession in a single fraction there are multiple 
rows with the same combination of Sequence, Mods and Charge
\item For cols: remove columns that are not neccessary any more
}
}
\examples{
##Use example peptide data set, read in and clean data
inputFile <- system.file("extData", "data.txt", package = "ComPrAn")
peptides <- peptideImport(inputFile)
peptides <- cleanData(peptides, fCol = "Search ID")
## separate chemical modifications and labelling into separate columns
peptides <- splitModLab(peptides) 
## remove unneccessary columns, simplify rows
peptides <- simplifyProteins(peptides) 

}
