% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pickPeptide.R
\name{pickPeptide}
\alias{pickPeptide}
\title{Select Top Peptide For Various Scenarios}
\usage{
pickPeptide(.data)
}
\arguments{
\item{.data}{a dataframe}
}
\value{
list of data frames
}
\description{
This function selects a single unique peptide to represent each 
`Protein Group Accession`
There are 2 ways of selecting peptides, both are perform as they are needed
for different tasks later on.
\enumerate{
\item Scenario A: select peptide occuring in most fractions, do this 
individually for labelled/unlabelled (max value for any peptide is equal to 
number of fractions) in case of ties, pick peptide whith highest 
`Precursor Area` in any fraction.
\item Scenario B: select peptide occuring in most fractions counting both
label states together (max value for any peptide is equal to twice the 
number of fractions) in case of ties, pick peptide with highest
`Precursor Area` in any fraction. Representative peptide in Scenario B is 
picked only for proteins that have shared peptide between label states.
}
}
\examples{

##Use example peptide data set, read in and clean data
inputFile <- system.file("extData", "data.txt", package = "ComPrAn")
peptides <- peptideImport(inputFile)
peptides <- cleanData(peptides, fCol = "Search ID")
## separate chemical modifications and labelling into separate columns
peptides <- splitModLab(peptides) 
## remove unneccessary columns, simplify rows
peptides <- simplifyProteins(peptides) 
## Pick representative peptide for each protein for both scenarios
peptide_index <- pickPeptide(peptides)
}
