% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-CogapsParams.R
\docType{class}
\name{CogapsParams-class}
\alias{CogapsParams-class}
\title{CogapsParams}
\description{
Encapsulates all parameters for the CoGAPS algorithm
}
\section{Slots}{

\describe{
\item{\code{nPatterns}}{number of patterns CoGAPS will learn}

\item{\code{nIterations}}{number of iterations for each phase of the algorithm}

\item{\code{alphaA}}{sparsity parameter for feature matrix}

\item{\code{alphaP}}{sparsity parameter for sample matrix}

\item{\code{maxGibbsMassA}}{atomic mass restriction for feature matrix}

\item{\code{maxGibbsMassP}}{atomic mass restriction for sample matrix}

\item{\code{seed}}{random number generator seed}

\item{\code{sparseOptimization}}{speeds up performance with sparse data
(roughly >80% of data is zero), note this can only be used with the
default uncertainty}

\item{\code{distributed}}{either "genome-wide" or "single-cell" indicating which
distributed algorithm should be used}

\item{\code{nSets}}{[distributed parameter] number of sets to break data into}

\item{\code{cut}}{[distributed parameter] number of branches at which to cut
dendrogram used in pattern matching}

\item{\code{minNS}}{[distributed parameter] minimum of individual set contributions
a cluster must contain}

\item{\code{maxNS}}{[distributed parameter] maximum of individual set contributions
a cluster can contain}

\item{\code{explicitSets}}{[distributed parameter] specify subsets by index or name}

\item{\code{samplingAnnotation}}{[distributed parameter] specify categories along
the rows (cols) to use for weighted sampling}

\item{\code{samplingWeight}}{[distributed parameter] weights associated with 
samplingAnnotation}

\item{\code{subsetIndices}}{set of indices to use from the data}

\item{\code{subsetDim}}{which dimension (1=rows, 2=cols) to subset}

\item{\code{geneNames}}{vector of names of genes in data}

\item{\code{sampleNames}}{vector of names of samples in data}

\item{\code{fixedPatterns}}{fix either 'A' or 'P' matrix to these values, in the
context of distributed CoGAPS (GWCoGAPS/scCoGAPS), the first phase is
skipped and fixedPatterns is used for all sets - allowing manual pattern
matching, as well as fixed runs of standard CoGAPS}

\item{\code{whichMatrixFixed}}{either 'A' or 'P', indicating which matrix is fixed}

\item{\code{takePumpSamples}}{whether or not to take PUMP samples}

\item{\code{checkpointInterval}}{how many iterations between each checkpoint (set to 0 to disable)}

\item{\code{checkpointInFile}}{file path to load checkpoint from}

\item{\code{checkpointOutFile}}{file path where checkpoint should be written to}
}}

