% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All-classes.R, R/initialize-methods.R,
%   R/plot-methods.R, R/projection-methods.R, R/show-methods.R
\docType{class}
\name{Pcp-class}
\alias{Pcp-class}
\alias{.Pcp}
\alias{getData}
\alias{getData,Pcp-method}
\alias{initialize,Pcp-method}
\alias{plot,Pcp,missing-method}
\alias{pcp}
\alias{pcp,matrix-method}
\alias{Pcp}
\alias{pcp}
\alias{pcp,matrix-method}
\alias{show,Pcp-method}
\title{Projection of points into one dimension.}
\usage{
getData(x, ...)

\S4method{getData}{Pcp}(x, n = NULL)

\S4method{initialize}{Pcp}(.Object, ..., classes, points.orig, line,
  points.onedim, index, class.color)

\S4method{plot}{Pcp,missing}(x, y, steps = "all", class.color = NULL, ...)

pcp(mat, ...)

\S4method{pcp}{matrix}(mat, classes, df = NULL, warn = TRUE,
  class.color = NULL, ...)

\S4method{show}{Pcp}(object)
}
\arguments{
\item{x}{matrix object for the function pcp otherwise it is a Pcp object}

\item{...}{additional arguments to pass on}

\item{n}{data to extract from Pcp (NULL gives all)}

\item{.Object}{internal object}

\item{classes}{vector in same order as rows in matrix}

\item{points.orig}{multidimensional points describing the original data}

\item{line}{multidimensional points describing a line}

\item{points.onedim}{a vector of points}

\item{index}{internal index from the projection}

\item{class.color}{user assigned group coloring scheme}

\item{y}{default plot param, which should be set to NULL}

\item{steps}{1,2,3,4,5,6 or "all"}

\item{mat}{matrix with samples on rows, PCs in columns. Ordered PCs, 
with PC1 to the left.}

\item{df}{degrees of freedom, passed to smooth.spline}

\item{warn}{logical indicating if a change in the default df argument should
generate a warning. mostly for internal use.}

\item{object}{Pcp object}
}
\value{
The pcp function returns an object of class Pcp
}
\description{
Project points onto a principal curve.
}
\details{
The resulting Pcp object containing results from a principal curve reduction
to one dimension. The group and the one dimensional points will be the
information needed to carry out a classification using the classify() 
function. As a help to illustrate the details of the dimension reduction,
the information from some critical steps is stored in the object. To
visually explore these there is a dedicated plot method for Pcp objects, use
plot().
}
\examples{

#use demo data
data(pcpMatrix)
classes <- rownames(pcpMatrix)

#run function
prj <- pcp(pcpMatrix, classes)

#getData accessor
getData(prj)

#getData accessor specific
getData(prj, "line")

#plot the result (if dim >2, then plot in 3d)
plot(prj)

#plot the result (if dim=2, then plot in 2d)
prj2 <- pcp(pcpMatrix[,1:2], classes)
plot(prj2)

}
\author{
Jesper R. Gadin and Jason T. Serviss
}
\keyword{projection}
