% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessory_functions.R
\name{specplot}
\alias{specplot}
\title{Create a basic plot of MS2 spectra}
\usage{
specplot(spec, ...)
}
\arguments{
\item{spec}{An object of class \code{\linkS4class{MS2spectrum}} or
\code{\linkS4class{pseudospectrum}}}

\item{...}{Additional graphical parameters to be passed to \code{plot()}}
}
\value{
A plot of the MS2 spectrum saved in the \code{spectrum} slot of
    \code{spec}.
}
\description{
\code{specplot} creates a very basic plot of MS2 spectra from
\code{\linkS4class{MS2spectrum}} or \code{\linkS4class{pseudospectrum}}
objects.
}
\examples{
load(file = system.file("extdata",
    "annotatedSpeclist.RData",
    package = "CluMSIDdata"))

specplot(annotatedSpeclist[[1]])

}
