% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Chromatograms-chromData.R
\name{chromData}
\alias{chromData}
\alias{msLevel}
\alias{chromIndex}
\alias{collisionEnergy}
\alias{dataOrigin}
\alias{mz}
\alias{mzMin}
\alias{mzMax}
\alias{precursorMz}
\alias{precursorMzMin}
\alias{precursorMzMax}
\alias{productMz}
\alias{productMzMin}
\alias{productMzMax}
\alias{filterChromData}
\alias{chromVariables}
\alias{chromData<-}
\alias{msLevel<-}
\alias{chromIndex<-}
\alias{collisionEnergy<-}
\alias{dataOrigin<-}
\alias{mz<-}
\alias{mzMin<-}
\alias{mzMax<-}
\alias{precursorMz<-}
\alias{precursorMzMin<-}
\alias{precursorMzMax<-}
\alias{productMz<-}
\alias{productMzMin<-}
\alias{productMzMax<-}
\alias{chromVariables<-}
\alias{chromData,Chromatograms-method}
\alias{chromData<-,Chromatograms-method}
\alias{chromVariables,Chromatograms-method}
\alias{chromIndex,Chromatograms-method}
\alias{chromIndex<-,Chromatograms-method}
\alias{collisionEnergy,Chromatograms-method}
\alias{collisionEnergy<-,Chromatograms-method}
\alias{dataOrigin,Chromatograms-method}
\alias{dataOrigin<-,Chromatograms-method}
\alias{msLevel,Chromatograms-method}
\alias{msLevel<-,Chromatograms-method}
\alias{mz,Chromatograms-method}
\alias{mz<-,Chromatograms-method}
\alias{mzMax,Chromatograms-method}
\alias{mzMax<-,Chromatograms-method}
\alias{mzMin,Chromatograms-method}
\alias{mzMin<-,Chromatograms-method}
\alias{length,Chromatograms-method}
\alias{precursorMz,Chromatograms-method}
\alias{precursorMz<-,Chromatograms-method}
\alias{precursorMzMin,Chromatograms-method}
\alias{precursorMzMin<-,Chromatograms-method}
\alias{precursorMzMax,Chromatograms-method}
\alias{precursorMzMax<-,Chromatograms-method}
\alias{productMz,Chromatograms-method}
\alias{productMz<-,Chromatograms-method}
\alias{productMzMin,Chromatograms-method}
\alias{productMzMin<-,Chromatograms-method}
\alias{productMzMax,Chromatograms-method}
\alias{productMzMax<-,Chromatograms-method}
\alias{filterChromData,Chromatograms-method}
\title{Chromatographic Peaks Metadata.}
\usage{
\S4method{chromData}{Chromatograms}(object, columns = chromVariables(object), drop = FALSE)

\S4method{chromData}{Chromatograms}(object) <- value

\S4method{chromVariables}{Chromatograms}(object)

\S4method{chromIndex}{Chromatograms}(object)

\S4method{chromIndex}{Chromatograms}(object) <- value

\S4method{collisionEnergy}{Chromatograms}(object)

\S4method{collisionEnergy}{Chromatograms}(object) <- value

\S4method{dataOrigin}{Chromatograms}(object)

\S4method{dataOrigin}{Chromatograms}(object) <- value

\S4method{msLevel}{Chromatograms}(object)

\S4method{msLevel}{Chromatograms}(object) <- value

\S4method{mz}{Chromatograms}(object)

\S4method{mz}{Chromatograms}(object) <- value

\S4method{mzMax}{Chromatograms}(object)

\S4method{mzMax}{Chromatograms}(object) <- value

\S4method{mzMin}{Chromatograms}(object)

\S4method{mzMin}{Chromatograms}(object) <- value

\S4method{length}{Chromatograms}(x)

\S4method{precursorMz}{Chromatograms}(object)

\S4method{precursorMz}{Chromatograms}(object) <- value

\S4method{precursorMzMin}{Chromatograms}(object)

\S4method{precursorMzMin}{Chromatograms}(object) <- value

\S4method{precursorMzMax}{Chromatograms}(object)

\S4method{precursorMzMax}{Chromatograms}(object) <- value

\S4method{productMz}{Chromatograms}(object)

\S4method{productMz}{Chromatograms}(object) <- value

\S4method{productMzMin}{Chromatograms}(object)

\S4method{productMzMin}{Chromatograms}(object) <- value

\S4method{productMzMax}{Chromatograms}(object)

\S4method{productMzMax}{Chromatograms}(object) <- value

\S4method{filterChromData}{Chromatograms}(
  object,
  variables = character(),
  ranges = numeric(),
  match = c("any", "all"),
  keep = TRUE
)
}
\arguments{
\item{object}{A \link{Chromatograms} object.}

\item{columns}{A \code{character} vector of chromatograms variables to extract.}

\item{drop}{A \code{logical} indicating whether to drop dimensions when
extracting a single variable.}

\item{value}{replacement value for \verb{<-} methods. See individual
method description or expected data type.}

\item{x}{A \link{Chromatograms} object.}

\item{variables}{For \code{filterChromData()}: \code{character} vector with the names
of the chromatogram variables to filter for. The list of available
chromatogram variables can be obtained with \code{chromVariables()}.}

\item{ranges}{For \code{filterChromData()} : a \code{numeric}
vector of paired values (upper and lower boundary) that define the
ranges to filter the \code{object}. These paired values need to be in the
same order as the \code{variables} parameter (see below).}

\item{match}{For \code{filterChromData()} : \code{character(1) }
defining whether the condition has to match for all provided
\code{ranges} (\code{match = "all"}; the default), or for any of them
(\code{match = "any"}) for chromatogram data to be retained.}

\item{keep}{For \code{filterChromData()}: \code{logical(1)}
defining whether to keep (\code{keep = TRUE}) or remove (\code{keep = FALSE})
the chromatogram data that match the condition.}
}
\value{
Refer to the individual function description for information on the
return value.
}
\description{
As explained in the \code{\link{Chromatograms}} class documentation, the
\code{Chromatograms} object is a container for chromatogram data that includes
chromatographic peaks data (\emph{retention time} and related intensity values,
also referred to as \emph{peaks data variables} in the context of
\code{Chromatograms}) and metadata of individual chromatograms (so called
\emph{chromatograms variables}).

The \emph{chromatograms variables} information can be accessed using the
\code{chromData()} function. it is also possible to access specific
chromatograms variables using \code{$}.

\verb{@chromData} can be accessed, replaced but also filtered/subsetted. Refer to
the sections below for more details.
}
\section{Chromatograms variables and accessor functions}{


The following chromatograms variables are guaranteed to be provided by a
\code{Chromatograms} object and to be accessible with either the \code{chromData()} or
a specific function named after the variables names:
\itemize{
\item \code{chromIndex}: an \code{integer} with the index of the chromatogram in the
original source file (e.g. \emph{mzML} file).
\item \code{collisionEnergy}: for SRM data, \code{numeric} with the collision energy of
the precursor.
\item \code{dataOrigin}: optional \code{character} with the origin of the data.
\item \code{msLevel}: \code{integer} defining the MS level of the data.
\item \code{mz}: optional \code{numeric} with the (target) m/z value for the
chromatographic data.
\item \code{mzMin}: optional \code{numeric} with the lower m/z value of the m/z range in
case the data (e.g. an extracted ion chromatogram EIC) was extracted from
a \code{Spectra} object.
\item \code{mzMax}: optional \code{numeric} with the upper m/z value of the m/z range.
\item \code{precursorMz}: for SRM data, \code{numeric} with the target m/z of the
precursor (parent).
\item \code{precursorMzMin}: for SRM data, optional \code{numeric} with the lower m/z of
the precursor's isolation window.
\item \code{precursorMzMax}: for SRM data, optional \code{numeric} with the upper m/z of
the precursor's isolation window.
\item \code{productMz} for SRM data, \code{numeric} with the target m/z of the
product ion.
\item \code{productMzMin}: for SRM data, optional \code{numeric} with the lower m/z of
the product's isolation window.
\item \code{productMzMax}: for SRM data, optional \code{numeric} with the upper m/z of
the product's isolation window.
}
}

\section{Filter Chromatograms variables}{


Functions that filter \code{Chromatograms} based on chromatograms variables
(i.e, \verb{@chromData} ) will remove chromatographic data that do not meet the
specified conditions. This means that if a chromatogram is filtered out, its
corresponding \verb{@chromData} and \verb{@peaksData} will be removed from the object
immediately.

The available functions to filter chromatogram data are:
\itemize{
\item \code{filterChromData()}: Filters numerical chromatographic data variables
based on the provided numerical \code{ranges}. The method returns a
\code{Chromatograms} object containing only the chromatograms that match the
specified conditions. This function results in an object with fewer
chromatograms than the original.
}
}

\examples{

# Create a Chromatograms object
cdata <- data.frame(
    msLevel = c(1L, 1L, 1L),
    mz = c(112.2, 123.3, 134.4),
    chromIndex = c(1L, 2L, 3L)
)

be <- backendInitialize(new("ChromBackendMemory"), chromData = cdata)

chr <- Chromatograms(be)

# Access chromatograms variables
chromData(chr)

# Access specific chromatograms variables
chromData(chr, columns = "msLevel")

msLevel(chr)

# Replace chromatograms variables
msLevel(chr) <- c(1L, 2L, 2L)

# Filter chromatograms variables
filterChromData(chr,
    variables = "msLevel", ranges = c(1L, 1L),
    keep = FALSE
)

}
\seealso{
\link{Chromatograms} for a general description of the \code{Chromatograms}
object.
\link{peaksData} for a general description of the chromatographic peaks
data available in the object, as well as how to access, replace and
subset them.
\link{processingQueue} for more information on the queuing
of processings and parallelization for larger dataset processing.
}
\author{
Philippine Louail
}
