% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChromBackendMemory.R
\name{ChromBackendMemory}
\alias{ChromBackendMemory}
\alias{backendInitialize,ChromBackendMemory-method}
\title{Improved in-memory Chromatographic data backend}
\usage{
ChromBackendMemory()

\S4method{backendInitialize}{ChromBackendMemory}(
  object,
  chromData = fillCoreChromVariables(data.frame()),
  peaksData = list(.EMPTY_PEAKS_DATA),
  ...
)
}
\arguments{
\item{object}{A \code{ChromBackendMemory} object.}

\item{chromData}{For \code{backendInitialize()} of a \code{ChromBackendMemory}
backend, a \code{data.frame} with the chromatographic data. If not
provided (or if empty), a default \code{data.frame} with the core
chromatographicvariables will be created.}

\item{peaksData}{For \code{backendInitialize()} of a \code{ChromBackendMemory}
backend, a \code{list} of \code{data.frame} with the peaks data. If not
provided (or if empty), a default \code{list} of empty \code{data.frame} with
the core peaks variables will be created. The length of the list
should match the number of chromatograms in the \code{chromData}
parameter.}

\item{...}{Additional parameters to be passed.}
}
\value{
Refer to the individual function description for information on the
return value.
}
\description{
\code{ChromBackendMemory}: This backend stores chromatographic data directly
in memory, making it ideal for small datasets or testing. It can be
initialized with a \code{data.frame} of chromatographic data via the \code{chromData}
parameter and a \code{list} of \code{data.frame} entries for peaks data using the
\code{peaksData} parameter. These data can be accessed with the \code{chromData()} and
\code{peaksData()} functions.
}
\examples{

## Method 1: Initialize backend directly
cdata <- data.frame(
    msLevel = c(1L, 1L, 1L),
    mz = c(112.2, 123.3, 134.4),
    dataOrigin = c("mem1", "mem2", "mem3")
)

pdata <- list(
    data.frame(
        rtime = c(12.4, 12.8, 13.2, 14.6),
        intensity = c(123.3, 153.6, 2354.3, 243.4)
    ),
    data.frame(
        rtime = c(45.1, 46.2),
        intensity = c(100, 80.1)
    ),
    data.frame(
        rtime = c(12.4, 12.8, 13.2, 14.6),
        intensity = c(123.3, 153.6, 2354.3, 243.4)
    )
)

cbm <- ChromBackendMemory()
cbm <- backendInitialize(cbm, chromData = cdata, peaksData = pdata)
cbm

## Method 2: Use Chromatograms constructor (recommended)
chr <- Chromatograms(ChromBackendMemory(), chromData = cdata, peaksData = pdata)
chr

}
\author{
Philippine Louail
}
