% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing_filtering_reduction.R
\name{read_sparse_matrix}
\alias{read_sparse_matrix}
\title{Read in one or multiple sparse matrices (10X format)}
\usage{
read_sparse_matrix(
  files_dir_list,
  ref = c("hg38", "mm10", "ce11")[1],
  verbose = TRUE
)
}
\arguments{
\item{files_dir_list}{A named character vector containing the full path
towards folders. Each folder should contain only the Feature file, the
Barcode file and the Matrix file (see description).}

\item{ref}{Reference genome (used to filter non-canonical chromosomes).}

\item{verbose}{Print ?}
}
\value{
Returns a list containing a datamatrix and cell annotation
}
\description{
Given one or multiple directories, look in each directory for a combination
of the following files :
\itemize{
\item A 'features' file containing unique feature genomic locations
-in tab separated format ( *_features.bed / .txt / .tsv / .gz),
e.g. chr, start and end
\item A 'barcodes' file containing unique barcode names
( _barcode.txt / .tsv / .gz)
\item A 'matrix' A file containing indexes of non zero entries
(_matrix.mtx / .gz)
}
}
\examples{
\dontrun{
sample_dirs = c("/path/to/folder1/", "/path/to/folder2/")
names(sample_dirs) = c("sample_1", "sample_2")
out <- read_sparse_matrix(sample_dirs, ref = "hg38")
head(out$datamatrix)
head(out$annot_raw)
}

}
