% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_differential_volcano_scExp}
\alias{plot_differential_volcano_scExp}
\title{Volcano plot of differential features}
\usage{
plot_differential_volcano_scExp(
  scExp_cf,
  group = "C1",
  logFC.th = 1,
  qval.th = 0.01,
  min.percent = 0.01
)
}
\arguments{
\item{scExp_cf}{A SingleCellExperiment object}

\item{group}{A character indicating the group for which to plot the
differential volcano plot. ("C1")}

\item{logFC.th}{Fold change threshold. (1)}

\item{qval.th}{Adjusted p-value threshold. (0.01)}

\item{min.percent}{Minimum fraction of cells having the feature active to
consider it as significantly differential. (0.01)}
}
\value{
A volcano plot of differential analysis of a specific cluster
}
\description{
Volcano plot of differential features
}
\examples{
data("scExp")
plot_differential_volcano_scExp(scExp,"C1")
}
