% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_filtering_clustering.R
\name{inter_correlation_scExp}
\alias{inter_correlation_scExp}
\title{Calculate inter correlation between cluster or samples}
\usage{
inter_correlation_scExp(
  scExp_cf,
  by = c("sample_id", "cell_cluster")[1],
  reference_group = unique(scExp_cf[[by]])[1],
  other_groups = unique(scExp_cf[[by]]),
  fullCor = TRUE
)
}
\arguments{
\item{scExp_cf}{A SingleCellExperiment}

\item{by}{On which feature to calculate correlation ("sample_id" or
"cell_cluster")}

\item{reference_group}{Reference group to calculate correlation with.
Must be in accordance with "by".}

\item{other_groups}{Groups on which to calculate correlation (can contain
multiple groups, and also reference_group). Must be in accordance with "by".}

\item{fullCor}{A logical specifying if the correlation matrix was calculated
on the entire set of cells (TRUE).}
}
\value{
A data.frame of average inter-correlation of cells in other_groups
with cells in reference_group
}
\description{
Calculate inter correlation between cluster or samples
}
\examples{
data(scExp)
inter_correlation_scExp(scExp)
}
