% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing_filtering_reduction.R
\name{find_top_features}
\alias{find_top_features}
\title{Find most covered features}
\usage{
find_top_features(
  scExp,
  n = 20000,
  keep_others = FALSE,
  prioritize_genes = FALSE,
  max_distanceToTSS = 10000,
  verbose = TRUE
)
}
\arguments{
\item{scExp}{A SingleCellExperiment.}

\item{n}{Either an integer indicating the number of top covered regions to
find or a character vector of the top percentile of features to keep (e.g.
'q20' to keep top 20\% features).}

\item{keep_others}{Logical indicating if non-top regions are to be removed
from the SCE or not (FALSE).}

\item{prioritize_genes}{First filter by loci being close to genes ? E.g. for
differential analysis, it is more relevant to keep features close to genes}

\item{max_distanceToTSS}{If prioritize_genes is TRUE, the maximum distance to
consider a feature close to a gene.}

\item{verbose}{Print ?}
}
\value{
A SCE with top features
}
\description{
Find the top most covered features that will be used for dimensionality
reduction. Optionally remove non-top features.
}
\examples{
data(scExp)
scExp_top = find_top_features(scExp, n = 4000, keep_others = FALSE)

}
