% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tagMatrix.R
\name{getTagMatrix}
\alias{getTagMatrix}
\title{getTagMatrix}
\usage{
getTagMatrix(
  peak,
  upstream,
  downstream,
  windows,
  type,
  by,
  TxDb = NULL,
  weightCol = NULL,
  nbin = NULL,
  verbose = TRUE,
  ignore_strand = FALSE
)
}
\arguments{
\item{peak}{peak peak file or GRanges object}

\item{upstream}{the distance of upstream extension}

\item{downstream}{the distance of downstream extension}

\item{windows}{a collection of region}

\item{type}{one of "start_site", "end_site", "body"}

\item{by}{one of 'gene', 'transcript', 'exon', 'intron', '3UTR' , '5UTR', or specified by users}

\item{TxDb}{TxDb or self-made granges object, served as txdb}

\item{weightCol}{column name of weight, default is NULL}

\item{nbin}{the amount of nbines}

\item{verbose}{print message or not}

\item{ignore_strand}{ignore the strand information or not}
}
\value{
tagMatrix
}
\description{
calculate the tag matrix
}
\details{
\code{getTagMatrix()} function can produce the matrix for visualization.
\code{peak} stands for the peak file. 
\code{window} stands for a collection of regions that users want to look into. 
Users can use \code{window} to capture the peak of interest.
There are two ways to input \code{window}. 

The first way is that users can use
\code{getPromoters()/getBioRegion()/makeBioRegionFromGranges()} to 
get \code{window} and put it into \code{getTagMatrix()}. 

The second way is that users can use \code{getTagMatrix()} to
call \code{getPromoters()/getBioRegion()/makeBioRegionFromGranges()}. In this way
users do not need to input \code{window} parameter but they need to input
\code{txdb}. 

\code{txdb} is a set of packages contained annotation 
of regions of different genomes. Users can
get the regions of interest through specific functions. These specific functions
are built in \code{getPromoters()/getBioRegion()}. Many regions can not be gain
through \code{txdb}, like insulator and enhancer regions. 
Users can provide these regions in the form of granges object. 
These self-made granges object will be passed to \code{TxDb} parameter and they will
be passed to \code{makeBioRegionFromGranges()} to produce the \code{window}.
In a word, \code{TxDb} parameter is a reference information. Users can
pass \code{txdb object} or self-made granges into it.

Details see \code{\link{getPromoters}},\code{\link{getBioRegion}} and \code{\link{makeBioRegionFromGranges}}

\code{upstream} and \code{downstream} parameter have different usages:

(1) \code{window} parameter is provided, 

if \code{type == 'body'}, \code{upstream} and \code{downstream} can use to extend 
the flank of body region.

if \code{type == 'start_site'/'end_site'}, \code{upstream} and \code{downstream} do not
play a role in \code{getTagMatrix()} function.

(2) \code{window} parameter is missing,

if \code{type == 'body'}, \code{upstream} and \code{downstream} can use to extend 
the flank of body region.

if \code{type == 'start_site'/'end_site'}, \code{upstream} and \code{downstream} refer to
the upstream and downstream of the start_site or the end_site.

\code{weightCol} refers to column in peak file. This column acts as a weight vaule. Details
see \url{https://github.com/YuLab-SMU/ChIPseeker/issues/15}

\code{nbin} refers to the number of bins. \code{getTagMatrix()} provide a binning method
to get the tag matrix.
}
