% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\docType{methods}
\name{plotManifold}
\alias{plotManifold}
\alias{plotManifold,SingleCellExperiment-method}
\title{Visualize the learned manifold}
\usage{
plotManifold(
  sce,
  color_by = c("phenoName", "featureName"),
  name,
  perplexity = 30,
  recalculate = FALSE
)
}
\arguments{
\item{sce}{A \code{SingleCellExperiment} object}

\item{color_by}{Indicates if nodes are colorized by a feature expression
('featureName') or phenotype label ('phenoName')}

\item{name}{A character string specifying the featureName or phenoName}

\item{perplexity}{Perplexity parameter for tSNE computation (default: 30)}

\item{recalculate}{Indicates if tSNE should be recalcuated and
results returned (default: FALSE)}
}
\value{
A \code{ggplot} object
}
\description{
Method visualizes an approximation of the manifold in the latent space
in two dimensions.
}
\details{
Visualizes the learned lower-dimensional manifold in two dimensions
using an approximation obtained by Barnes-Hut implementation of
t-Distributed Stochastic Neighbor Embedding
(tSNE; van der Maaten and Hinton 2008). Each point in this plot represents
a sample. Points can be colorized according
to feature expression or experimental metadata. The points' coloration can
be defined via the attributes \code{color_by} and \code{name},
respectively. A previously computed tSNE visualization will be reused if
it was set accordingly (see \code{manifold2D<-}). The parameter
\code{perplexity} is used for the tSNE calculation.
}
\examples{
# Example data
data(exSCE)

plotManifold(exSCE, color_by="featureName", name="feature_10")
gp <- plotManifold(exSCE, color_by="phenoName", name="age",
                  recalculate=TRUE)
manifold2D(exSCE) <- gp
}
\references{
van der Maaten, L.J.P. & Hinton, G.E., 2008. Visualizing
High-Dimensional Data Using t-SNE. Journal of Machine Learning Research,
9, pp.2579-2605.
}
\seealso{
\code{Rtsne} \code{latentSpace} \code{manifold2D}
}
\author{
Daniel C. Ellwanger
}
