% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function-verify_seq.R
\name{bc_splitVDJ}
\alias{bc_splitVDJ}
\title{Parse VDJ recombination (experimental)}
\usage{
bc_splitVDJ(
  seqs,
  v_part = "TCCAGTAG",
  d_fwd = "TCTACTATCGTTACGAC",
  d_inv = "GTCGTAACGATAGTAGA",
  j_part = "GTAGCTACTACCG"
)
}
\arguments{
\item{seqs}{a character vector contains the barcode sequences.}

\item{v_part}{a string given the V part sequence.}

\item{d_fwd}{a string given the D region forwrad sequence.}

\item{d_inv}{a string given the D region inverted sequence.}

\item{j_part}{a string given the J region sequence.}
}
\value{
A list contains two data.frame named \code{add.del.ok} and \code{add.del.err}, which contain
columns with the remaining constant parts and inserted/deleted parts
}
\description{
Script to split barcodes from the genetic 'barcode mouse' construct as generated in
the lab of Ton Schumacher (NKI, NL) in its remaining constant V, D and J elements and
the modified elements (additions/deletions) in between those constant parts.
}
\examples{
## prepare input sequence
seq_v <- c(
    "TCCAGTAGCTACTATCGTTACGAGTAGCTACTACCG",
    "TCCAGTAGCTACTATCGTTACGACGTAGCTACTACCG",
    "TCCATACTATCGTTACGACGTAGCTACTACG",
    "TCCAGTAGTCGTAACGATAGTAGAGTAGCTACTACCG"
    )

## split the sequences
bc_splitVDJ(seq_v)

}
