% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/method-BarcodeObj.R
\name{bc_2df}
\alias{bc_2df}
\alias{bc_2dt}
\alias{bc_2matrix}
\alias{bc_2df,BarcodeObj-method}
\alias{bc_2dt,BarcodeObj-method}
\alias{bc_2matrix,BarcodeObj-method}
\title{Transforms BarcodeObj object into another data type}
\usage{
bc_2df(barcodeObj)

bc_2dt(barcodeObj)

bc_2matrix(barcodeObj)

\S4method{bc_2df}{BarcodeObj}(barcodeObj)

\S4method{bc_2dt}{BarcodeObj}(barcodeObj)

\S4method{bc_2matrix}{BarcodeObj}(barcodeObj)
}
\arguments{
\item{barcodeObj}{A \code{BarcodeObj} object.}
}
\value{
A \code{data.frame}, with two columns: \code{barcode_seq} and
\code{count}.
}
\description{
Transforms BarcodeObj object into \code{data.frame}, \code{data.table} or
\code{matrix}.
}
\examples{
data(bc_obj)

bc_obj <- bc_cure_depth(bc_obj)

# BarcodeObj to data.frame
bc_2df(bc_obj)

# BarcodeObj to data.table
bc_2dt(bc_obj)

# BarcodeObj to matrix
bc_2matrix(bc_obj)

###
}
