% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07_prediction.R
\name{predictConcentration}
\alias{predictConcentration}
\title{Predict concentrations from intensity values based on a given calibration
curve}
\usage{
predictConcentration(CC_res, newdata, verbose = TRUE)
}
\arguments{
\item{CC_res}{\strong{list} \cr Results of \code{\link{CalibraCurve}}.}

\item{newdata}{\strong{numeric} \cr A vector of intensity values for which to
predict concentrations.}

\item{verbose}{\strong{logical(1)} \cr If TRUE, a warning message is given if
estimated concentrations
are outside of the linear range.}
}
\value{
A data frame with the following columns:
\itemize{
\item \code{intensity}: The input intensity values.
\item \code{predicted_concentrations}: The predicted concentrations based on the
calibration curve.
\item \code{linear_range}: A logical vector indicating whether the predicted
concentrations are within the final linear range.
}
}
\description{
Predict concentrations from intensity values based on a given calibration
curve
}
\details{
The function will give a warning if any of the predicted concentrations are
outside the final linear range. This is important to ensure that the
predictions are reliable and within the linear range of the calibration
curve.
}
\examples{
file <- system.file("extdata", "MSQC1", "msqc1_dil_GGPFSDSYR.rds",
        package = "CalibraCurve")
D <- readDataSE(file, concColName = "amount_fmol",
        substColName = "Substance")
RES <- CalibraCurve(D)
newdata <- c(1000000, 10000000, 100000000) # 1e6, 1e7, 1e8
predictConcentration(RES$RES[[4]], newdata = newdata)
}
