% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutFilterQual.R
\name{mutFilterQual}
\alias{mutFilterQual}
\title{mutFilterQual}
\usage{
mutFilterQual(
  maf,
  panel = "Customized",
  tumorDP = 20,
  normalDP = 10,
  tumorAD = 5,
  normalAD = Inf,
  VAF = 0.05,
  VAFratio = 0
)
}
\arguments{
\item{maf}{An MAF data frame, generated by \code{\link{vcfToMAF}} function.}

\item{panel}{The sequencing panel applied on the dataset. Parameters
for \code{\link{mutFilterQual}} function are set differently for different
panels. Default: "Customized". Options: "MSKCC", "WES".}

\item{tumorDP}{Threshold of tumor total depth. Default: 20}

\item{normalDP}{Threshold of normal total depth. Default: 10}

\item{tumorAD}{Threshold of tumor alternative allele depth. Default: 5}

\item{normalAD}{Threshold of normal alternative allele depth. Default: Inf}

\item{VAF}{Threshold of VAF value. Default: 0.05}

\item{VAFratio}{Threshold of VAF ratio (tVAF/nVAF). Default: 0}
}
\value{
An MAF data frame where some variants
have Q tag in CaTag column for sequencing quality filtration
}
\description{
Filter variants in low sequencing quality or low confidence.
}
\examples{
maf <- vcfToMAF(system.file("extdata",
"WES_EA_T_1_mutect2.vep.vcf", package="CaMutQC"))
mafF <- mutFilterQual(maf)
}
