% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{makeTags}
\alias{makeTags}
\title{A short function that returns the default CTdata tags and, if
provided, additional data-specific tags.}
\usage{
makeTags(x)
}
\arguments{
\item{x}{An optional \code{character()} containing specific tags.}
}
\value{
A \code{character} containing the default tags and optional
data-specific tags. If \code{x} is missing or is of length 0, the
default tags are returned. Otherwise, a vector of length equal to
\code{length(x)} is returned.
}
\description{
A short function that returns the default CTdata tags and, if
provided, additional data-specific tags.
}
\examples{

CTdata:::makeTags() ## only default tags

CTdata:::makeTags(character()) ## only default tags

CTdata:::makeTags("myTag") ## one additional tag

CTdata:::makeTags(c("myTag", "myOtherTag")) ## two additional tag
}
