% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeansNormalize.R
\name{kmeansNormalize}
\alias{kmeansNormalize}
\title{Perform k-means clustering, normalize anscombe data and calculate cluster 
variances for a sample.}
\usage{
kmeansNormalize(ansDataVec, numClusters = 4)
}
\arguments{
\item{ansDataVec}{Anscombe transformed count data for a sample.}

\item{numClusters}{A number indicating the number of clusters to use for 
k-means clustering. (default: 4)}
}
\value{
DataFrame containing the normalized counts, 
   cluster information and the variance of the cluster in the sample.
}
\description{
This function performs normalization on the anscombe transformed data by
clustering them using k-means algorithmn and utilizing the information from
clusters. It returns an DataFrame object  normalized counts,
cluster information and the variance of that cluster for that sample.
}
\examples{
exCount <- c(1,2,3,4,5,6,7,8,9,10)
kmeansEx <- kmeansNormalize(exCount,numClusters=2)
kmeansEx
}
\seealso{
\code{\link{normalizeData}} which iterates over this function.
}
