% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_cells.R
\name{scoreCellsCore}
\alias{scoreCellsCore}
\title{Generate CSOA scores from overlap data frame for a single gene set}
\usage{
scoreCellsCore(
  geneSetExp,
  overlapDF,
  colStr = "CSOA",
  mtMethod = c("BY", "BH"),
  jaccardCutoff = NULL,
  osMethod = c("log", "minmax"),
  pairFileName = NULL,
  keepOverlapOrder = FALSE,
  ...
)
}
\arguments{
\item{geneSetExp}{A gene expression non-sparse matrix with the rows
restricted to the genes for which cell sets will be computed.}

\item{overlapDF}{Overlap data frame.}

\item{colStr}{Name of column where CSOA scores will be stored.}

\item{mtMethod}{Multiple testing correction method. Choose between
Benjamini-Yekutieli ('BY') and Benjamini-Hochberg('BH').}

\item{jaccardCutoff}{A cutoff used in the filtering of edges with low
Jaccard scores. If \code{NULL} (as default), no filtering of such edges
will be performed.}

\item{osMethod}{Method used to compute overlap scores.
Options are "log" and "minmax".}

\item{pairFileName}{The name of the file where the pair data frame
will be saved.}

\item{keepOverlapOrder}{Whether to keep the rank-based order of overlaps
in the pair score file, as opposed to changing it to a
pair score-based order.}

\item{...}{Additional arguments passed to \code{mtCorrectDF}.}
}
\value{
A data frame with a column corresponding to the CSOA scores.
}
\description{
This function computes per-cell CSOA scores from overlap data frame for
a single gene set.
}
\keyword{internal}
