% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/utils.R
\name{expMat}
\alias{expMat}
\alias{expMat.default}
\alias{expMat.Seurat}
\alias{expMat.SingleCellExperiment}
\alias{expMat.dgCMatrix}
\alias{expMat.matrix}
\title{Extracts the data expression matrix from object}
\usage{
expMat(scObj, ...)

\method{expMat}{default}(scObj, genes = NULL, ...)

\method{expMat}{Seurat}(scObj, ...)

\method{expMat}{SingleCellExperiment}(scObj, ...)

\method{expMat}{dgCMatrix}(scObj, ...)

\method{expMat}{matrix}(scObj, ...)
}
\arguments{
\item{scObj}{A Seurat object, SingleCellExperiment object, or
expression matrix.}

\item{...}{Additional arguments.}

\item{genes}{Genes retained in the expression matrix. If NULL, all genes
will be retained}
}
\value{
An expression matrix.
}
\description{
This function extracts the data expression matrix from object as a
non-sparse matrix. Selected genes can be specified as input.
}
\examples{
library(Seurat)
mat <- matrix(0, 6, 4)
mat[sample(length(mat), 7)] <- sample(3, 7, TRUE)
seuratObj <- CreateSeuratObject(counts = mat)
seuratObj <- NormalizeData(seuratObj)
expMat(seuratObj)

}
