% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_qc.R
\name{plot_hist}
\alias{plot_hist}
\title{Create a plotly plot from a distribution of values}
\usage{
plot_hist(
  mat,
  title = NULL,
  xlab = "Values",
  ylab = "Frequency",
  show.grid = FALSE
)
}
\arguments{
\item{mat}{A matrix with the data to plot.}

\item{title}{A character scalar for the title of the plot.}

\item{xlab}{Character scalar for label of the x-axis.}

\item{ylab}{Character scalar for label of the y-axis.}

\item{show.grid}{A boolean for whether to show the grid lines.}
}
\value{
A plotly plot with the distribution of read counts.
}
\description{
This function creates a plotly plot with the distribution of values for each
column in the \code{mat} matrix, using different colors for each column.
The legend will show the column names from \code{mat}, and the plot will have
the title "Distribution of read counts".
}
\examples{
library(CRISPRball)
cts <- read.delim(system.file("extdata", "escneg.count_normalized.txt",
    package = "CRISPRball"
), check.names = FALSE)
cts.log <- as.matrix(log2(cts[, c(-1, -2)] + 1))
colnames(cts.log) <- colnames(cts)[c(-1, -2)]

plot_hist(cts.log,
    title = "Distribution of read counts",
    xlab = "log2(counts + 1)", ylab = "Frequency"
)
}
\author{
Jared Andrews
}
