% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulator.R
\name{simcells}
\alias{simcells}
\title{simcells}
\usage{
simcells(channels = 2, spots.per.image = c(1, 1),
  one.location = c(50, 50), image.dimension = rep(100, 2),
  signal.level = list(700, 700), noise.level = c(200, 200),
  spot.size = list(30, 30), agreement.number = 1)
}
\arguments{
\item{channels}{Integer. The number of channels for each sample. Default is 2.}

\item{spots.per.image}{Numeric vector. The number of spots in each image (channel). The length
of the vector equals to the number of channels. Default is one spot per channel.}

\item{one.location}{Numeric vector. The central location of the matched spots across the channels
(in pixel) coordinates. Default is (X,Y) = (50,50).}

\item{image.dimension}{Numeric vector. The image dimension (in pixels). Default is 100 x 100.}

\item{signal.level}{List. The lambda parameter of the Poisson distribution that generates the
true spot (pixel) signals. The list has as many components (length) as the number of channels.
The number of elements of each component equals to the number of spots in each particular channel.
Default is list(700,700).}

\item{noise.level}{Numeric vector. The sigma parameter of the Normal distribution that generates the
image noise level. The length of the vector equals to the number of channels. Default is c(200,200).}

\item{spot.size}{List. The size of each spot on each channel (in pixels). The list has as many components
(length) as the number of channels. The number of elements of each component equals to the number of
spots in each particular channel. Default is list(30,30).}

\item{agreement.number}{Integer. It defines how many spot pairs are matched, i.e. they are located in the
same coordinates across channels. These reflect true cells. Default is 1 corresponding to a single-cell
case study.}
}
\value{
The image(s) with the generated spot(s). It consists of the data matrices and the location of the spot centers.
}
\description{
The main function to simulate spots of various numbers, sizes, signals in one or multiple images
  of a given dimension.
}
\examples{
r<-simcells(channels = 2, spots.per.image = c(2, 3), one.location = c(50, 50),
image.dimension = rep(200, 2), signal.level = list(c(1000, 1000), c(1000, 700, 300)),
noise.level = c(100, 100),spot.size = list(c(81, 100), c(26, 29, 50)), agreement.number = 1)

r<-simcells(channels = 2, spots.per.image = c(0, 0), image.dimension = rep(200, 2),
signal.level = list(c(),c()),noise.level = c(0, 0), spot.size = list(c(), c()))
}
