% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluo_est.R
\name{readFiles}
\alias{readFiles}
\title{readFiles}
\usage{
readFiles(iDirectory, BFdirectory, CHdirectory, separator = "_",
  image.type = c("BF", "Red", "Green"), bits = 2^16)
}
\arguments{
\item{iDirectory}{Character string. The directory where all images are stored. The images should be in
the same format. Available choices are: C01, BMP, JPEG and PNG. The function recognizes the format automatically.
If ommitted, the function assumes that the txt data already exist at the predefined folders.}

\item{BFdirectory}{Character string. The directory to store the .txt converted Bright Field images.}

\item{CHdirectory}{Character string. The directory to store the .txt converted channel (e.g. Red/Green) images}

\item{separator}{Character string. This is the <<separator2>> parameter that removes the Bright Field ("BF") and
channel indicators (IDs) from the image file names. Default is "_".}

\item{image.type}{Character string. A triplet of IDs to characterize the type of images under study. They refer to
the ImageType part of the original image or txt file names. Default is c("BF","Red","Green").}

\item{bits}{Numeric. The image bits. It is used to unnormalize the C01 signals from readCellomics(). It does
not affect the signals of other image types. Default is 2^16.}
}
\value{
A list with the followign components:
  BF: the files names of the Bright Field converted data matrices.
  CH1: the files names of the converted data matrices of one channel.
  CH2: the files names of the converted data matrices of the other channel.
  separator: the separator being used.
  image.type: the image type IDs.
  dateIndex: a date index to be used in saving the output files.
}
\description{
Reads the image data that are going to be analyzed. It converts the images into txt files. The images should
be in .C01 (high resolution) or .BMP, or .JPG or .PNG format. The file names should be of the form:
}
\details{
"RunID(separator1)WellID(separator2)ImageType.ImageFormat

For example in "1772-062-248_A01@BF.C01", RunID = 1772-062-248", separator1 = _, WellID = A01, separator2 = @
  ImageType = BF, ImageFormat = C01. The function expects to see both Bright Field and channel images. It will
  store them in different directories. It will return a list of the respective .txt file names. Note that separator1
  and separator2 CAN BE the same character (e.g. "_").

If the images have been already converted, then the txt files should be stored in the above form with ImageFormat = txt.

readFiles() will take the minimum overlapping sets. Converted images not present in any
of the channels or the Bright Field list will be reported and discarded.
}
\examples{
library(CONFESSdata)

### set your directories
basedir<-"~/"
data_path<-system.file("extdata",package="CONFESSdata")

## to read txt files
files<-readFiles(iDirectory=NULL,
                 BFdirectory=paste(data_path,"/BF",sep=""),
                 CHdirectory=paste(data_path,"/CH",sep=""),
                 separator = "_",image.type = c("BF","Green","Red"),
                 bits=2^16)
                 
## to convert from BMP/JPEG images
#write_dir<-"~/converted_images/"
#files<-readFiles(iDirectory=data_path,
#                 BFdirectory=paste(write_dir,"/BF",sep=""),
#                 CHdirectory=paste(write_dir,"/CH",sep=""),
#                 separator = "_",image.type = c("BF","Green","Red"),
#                 bits=2^16)                  
}
