% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_fluo_est.R
\name{plotImages}
\alias{plotImages}
\title{plotImages}
\usage{
plotImages(number, origImg, chaImgs, binChaImgs, stats, pix, log.transform,
  minDiff, sample, image.type)
}
\arguments{
\item{number}{Integer. An index number that regulates the fluorescence estimation procedure.}

\item{origImg}{Data matrix. The original BF image to be read and processed.}

\item{chaImgs}{List. A list of the channel images (data matrices) of a sample.}

\item{binChaImgs}{List. A list of binary segmented channel image data.}

\item{stats}{List. A series of foreground and background statistics.}

\item{pix}{List. A list of bright spot coordinates in the channels.}

\item{log.transform}{Logical. If TRUE the image data are plotted in the log scale.}

\item{minDiff}{Float. the mu_hat of the H0: image-to-noise ratio =
log(foreground_signal) - log(background_signal) = mu_hat. Rejection of H0
implies that the identified spot is brighter than background. Default is 0.5.}

\item{sample}{Character string. The sample ID.}

\item{image.type}{Character string. A triplet of IDs to characterize the type of images under study. They refer to
the ImageType part of the original image or txt file names.}
}
\value{
the plotted results and statistics of the signal-to-noise ratio
}
\description{
It generates the plotted results.
}
\keyword{internal}
