% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluo_est.R
\name{defineLocClusters}
\alias{defineLocClusters}
\title{defineLocClusters}
\usage{
defineLocClusters(LocData, dims = rep(512, 2),
  out.method = "interactive.clustering", subset = c(),
  separator = "_", savePlot = "screen")
}
\arguments{
\item{LocData}{The table of the location estimates obtained by spotEstimator().}

\item{dims}{Numeric vector. The dimensions of the image data. Default is rep(512,2).}

\item{out.method}{Character string. The method by which to flag outliers: "interactive.clustering" or "interactive.manual"
or "manual". Default is "interactive.clustering".
The interactive options work through interactive plots: "interactive.clustering" enables
the user to highight the outliers via co-centric circles in the plot while "interactive.manual"
asks the user to click on the plot to highlight the outliers (to confirm & finalize the picks
in each plot the user has to select the "stop" command (Windows) or press the right click in
Linux/Mac. Note that 'interactive.clustering' works when one has more then or equal to 15 samples IN EACH CATEGORY
(Run/Well combination).
The "manual" option simply gives back the original table of location estimates with the last column
being a series of "confidence". The outliers should be manually annotated by inserting "outlier" in the
appropriate rows of the last column.}

\item{subset}{List. It allows the user to run the algorithm for a subset of data (run ids and wells).
Default c() using all data. Otherwise put the run IDs and the wells (left and/or right) in a list,
e.g. list(c("1772-115-xxx","1772-115-yyy"),"left").}

\item{separator}{Character string. It refers to <<separator1>> parameter described in readFiles() that separates the
run ID from the Well ID in the original image (converted) file names. Default is "_".}

\item{savePlot}{Character string. Directory to store the plots if out.method = manual. Its value can be an existing directory
or "screen" that prints the plot only on the screen. Default is the current working directory, getwd().}
}
\value{
A list of components summarizing the location estimates and their quality control statistics:
  Results: The table of the location estimates from spotEstimator() with an extra "QCgroup" labelled column that flags the samples
    either by "confidence" or by "outlier" (the locations that have been selected as outliers from the interactive plots). If
    out.method = "manual" the column includes a series of "confidence" entries. The outliers should be manually labelled.
  BFdata: the outlier estimates of spotEstimator(). They are kept here for processing in the second spotEstimator() step. See spotEstimator()
    for more details.
  Processed.Files: the samples that have been processed by spotEstimator(). Also kept from the first spotEstimator() step. They
    will be processed in the second spotEstimator() step.
  Outlier.indices: a vector of outlier sample indices. They are generated from the flagging of the outliers via interactive plots.
    They have to be manually specified if out.method = "manual".
  Medians: the 2-dimenional medians by run ID and wellID sets.
  Wellsets: a matrix showing the directionality of the well IDs.
  BFarea: the size of the pseudospot.
  image.type: the image type IDs.
  dateIndex: a date index to be used in saving the output files.
}
\description{
It performs quality check on the estimated location of spotEstimator() in order to flag possible outliers.
The flagging is done both visually and statistically using the Grubbs test.
}
\details{
The outlier locations will be re-estimated by BF image modelling or adjusted as the 2-dimensional median of all
  non-outlying locations.
}
\examples{
library(CONFESSdata)
### set your directories
basedir<-"~/"
data_path<-system.file("extdata",package="CONFESSdata")
files<-readFiles(iDirectory=NULL,
                 BFdirectory=paste(data_path,"/BF",sep=""),
                 CHdirectory=paste(data_path,"/CH",sep=""),
                 separator = "_",image.type = c("BF","Green","Red"),
                 bits=2^16)

#this example is run using out.method="manual" (not interactive) 
clu <- defineLocClusters(LocData=estimates,out.method="manual",savePlot="screen")
}
