% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_fluo_est.R
\name{SpotStats}
\alias{SpotStats}
\title{spotStats}
\usage{
SpotStats(img, chaImgs, binChaImgs, center, other.spots, BFcoords, BFarea,
  log.transform, warning, minDiff, separator, image.type)
}
\arguments{
\item{img}{Data matrix. The original data of the BF image to be read and processed.}

\item{chaImgs}{List. A list of the channel images (data matrices) of a sample.}

\item{binChaImgs}{List. A list of binary segmented channel image data.}

\item{center}{Data matrix. The 2-dimensional location of the spot's representative center.}

\item{BFcoords}{List. A list of statistics describing the C1 chip line patterns (for BF image modelling).}

\item{BFarea}{Integer. Defines a rectangular pseudo-spot size whose fluorescence will be estimated. This is
mainly used in BF image modeling where a fluorescence spot could not be originally detected. The value of
this parameter is also used as a cut-off to find matched spots across channel of the same sample image.}

\item{log.transform}{Logical. If TRUE the image data are plotted in the log scale.}

\item{warning}{Character string. An indicator of the estimation type that has been internally performed, i.e.
fluorescence-based or BF image modelling.}

\item{minDiff}{Float. the mu_hat of the H0: image-to-noise ratio =
log(foreground_signal) - log(background_signal) = mu_hat. Rejection of H0
implies that the identified spot is brighter than background. Default is 0.5.}

\item{separator}{Character string. Removes the Bright Field ("BF") and channel indicators from the
image file names (see <<separator2>> in readFiles()).}

\item{image.type}{Character string. A triplet of IDs to characterize the type of images under study. They refer to
the ImageType part of the original image or txt file names.}
}
\value{
A table of location and fluorescence estimated with accompanied plots
}
\description{
It produces a table of estimated spot locations and fluorescence signals accompanied by informative plots.
  It can process the results of either spotCoords() for fluorescence-based estimation or forceBF() for
  BF image modelling estimation.
}
\keyword{internal}
