% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{select_genes_on_mutations}
\alias{select_genes_on_mutations}
\title{Filter dataset by genes' mutation count}
\usage{
select_genes_on_mutations(mutmatrix, n, desc = TRUE)
}
\arguments{
\item{mutmatrix}{input dataset (mutational matrix) to be reduced}

\item{n}{number of genes to be kept}

\item{desc}{TRUE: select the n least mutated genes,
FALSE: select the n most mutated genes}
}
\value{
the modified dataset (mutational matrix)
}
\description{
Dataset filtering on genes, based on their mutation count
}
\examples{

# keep information on the 100 most mutated genes
select_genes_on_mutations(example_dataset(), 5)
# keep information on the 100 least mutated genes
select_genes_on_mutations(example_dataset(), 5, desc = FALSE)

}
