% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils_CHETAH.R
\name{CHETAHclassifier}
\alias{CHETAHclassifier}
\title{Identification of cell types aided by hierarchical clustering}
\usage{
CHETAHclassifier(
  input,
  ref_cells = NULL,
  ref_profiles = NULL,
  ref_ct = "celltypes",
  input_c = NA,
  ref_c = NA,
  thresh = 0.1,
  gs_method = c("fc", "wilcox"),
  cor_method = c("spearman", "kendall", "pearson", "cosine"),
  clust_method = c("average", "single", "complete", "ward.D2", "ward.D", "mcquitty",
    "median", "centroid"),
  clust_dist = bioDist::spearman.dist,
  n_genes = 200,
  pc_thresh = 0.2,
  p_thresh = 0.05,
  fc_thresh = 1.5,
  subsample = FALSE,
  fix_ngenes = TRUE,
  plot.tree = FALSE,
  only_pos = FALSE,
  print_steps = FALSE
)
}
\arguments{
\item{input}{\strong{required}: an input SingleCellExperiment.
(see: \href{https://bioconductor.org/packages/release/bioc/html/SingleCellExperiment.html}{Bioconductor},
and the vignette \code{browseVignettes("CHETAH")})}

\item{ref_cells}{\strong{required}: A reference SingleCellExperiment, with
the cell types in the "celltypes" colData (or otherwise defined in \code{ref_ct}.}

\item{ref_profiles}{\emph{optional} In case of bulk-RNA seq or micro-arrays,
an expression matrix with one (average) reference expression profile
per cell type in the columns. (`ref_cells` must be left empty)}

\item{ref_ct}{the colData of \code{ref_cells} where the cell types are stored.}

\item{input_c}{the name of the assay of the input to use.
\code{NA} (default) will use the first one.}

\item{ref_c}{same as \code{input_c}, but for the reference.}

\item{thresh}{the initial confidence threshold, which can be changed after running
by \code{\link{Classify}})}

\item{gs_method}{method for gene selection. In every node of the tree:
"fc" = quick method: either a fixed number (\code{n_genes})
of genes is selected with the highest fold-change (default),
or genes are selected that have a fold-change higher than \code{fc_thresh}
(the latter is used when \code{fix_ngenes = FALSE}) . \cr
"wilcox": genes are selected based on fold-change (\code{fc_thresh}),
percentage of expression (\code{pc_thresh}) and p-values (\code{p_thresh}),
p-values are found by the wilcox test.}

\item{cor_method}{the correlation measure: one of:
"spearman" (default), "kendall", "pearson", "cosine"}

\item{clust_method}{the method used for clustering the reference profiles.
One of the methods from \code{\link[stats]{hclust}}}

\item{clust_dist}{a distance measure, default: \code{\link[bioDist]{spearman.dist}}}

\item{n_genes}{The number of genes used in every step. Only used if
\code{fix_ngenes = TRUE}}

\item{pc_thresh}{when: \emph{gs_method = "wilcox"}, only genes are selected
for which more than a \code{pc_tresh} fraction of a reference group of cells
express that gene}

\item{p_thresh}{when: \emph{gs_method = "wilcox" }, only genes are selected
that have a p-value < \code{p_thresh}}

\item{fc_thresh}{when: \emph{gs_method = "wilcox" or gs_method = "fc"
AND fix_ngenes = FALSE},
only genes are selected that have a log2 fld-change > \code{fc_thresh}
between two reference groups. \cr
\strong{if this mode is selected, the reference must be in the log2 space}.}

\item{subsample}{to prevent reference types with a lot of cells to influence
the gene selection, subsample types with more that \code{subsample} cells}

\item{fix_ngenes}{when: \emph{gs_method = "fc"} use a fixed number of genes
for all correlations. when: \emph{gs_method = "wilcox"}
use a maximum of genes per step.
When \code{fix_ngenes = FALSE & gs_methode = "fc"} \code{fc_thresh}
is used to define the fold-change cut-off for gene selection.}

\item{plot.tree}{Plot the classification tree.}

\item{only_pos}{\emph{not recommended}: only use genes for a reference type
that are higher expressed in that type, than the others in that node.}

\item{print_steps}{whether the number of genes (postive and negative)
per step per ref_cell_type should be printed}
}
\value{
A SingleCellExperiment with added:
-  input$celltype_CHETAH
a named character vector that can directly be used in any other workflow/method.
-  "hidden" `int_colData` and `int_metadata`, not meant for direct interaction, but
which can all be viewed and interacted with using: `PlotCHETAH` and `CHETAHshiny`
A list containing the following objects is added to input$int_metadata$CHETAH
\itemize{
  \item \strong{classification} a named vector: the classified types
  with the corresponding names of the input cells
  \item \strong{tree} the hclust object of the classification tree
  \item \strong{nodetypes} A list with the cell types under each node
  \item \strong{nodecoor} the coordinates of the nodes of the classification tree
  \item \strong{genes} A list per node, containing a list per
  reference type with the genes used for the profile scores of that type
  \item \strong{parameters} The parameters used
}
A nested DataFrame is added to input$int_colData$CHETAH.
It holds 3 top-levels DataFrames
\itemize{
  \item \strong{prof_scores} A list with the profile scores
  \item \strong{conf_scores} A list with the confidence scores
  \item \strong{correlations} A list with the correlations of the
  input cells to the reference profiles
}
}
\description{
CHETAH classifies an input dataset by comparing it to
a reference dataset in a stepwise, top-to-bottom fashion.
See 'details' for a full explanation.
\emph{NOTE: We recommend to use all the default parameters}
}
\details{
CHETAH will hierarchically cluster reference data
to produce a classification tree (ct).
In each node of the ct, CHETAH will
assign each input cell to on of the two branches, based on gene selections,
correlations and calculation of profile and confidence scores.
The assignement will only performed if the confidence score for
such an assignment is higher than the Confidence Threshold.
If this is not the case, classification for the cell will stop in the current node.
Some input cells will reach the leaf nodes of the ct (the pre-defined cell types),
these classifications are called \strong{final types}
For other cells, assignment will stop in a node. These classifications
are called \strong{intermediate types}.  \cr
}
\examples{
data('input_mel')
data('headneck_ref')
## Melanoma data from Tirosh et al. (2016) Science
input_mel
## Head-Neck data from Puram et al. (2017) Cancer Cell
headneck_ref
input_mel <- CHETAHclassifier(input = input_mel, ref_cells = headneck_ref)
}
