% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc_network.R
\name{cc_network}
\alias{cc_network}
\title{Network Plot Function}
\usage{
cc_network(
  cc_df,
  colours = paletteMartin(),
  option = "A",
  n_top_ints = 20,
  node_size = 2.75,
  label_size = 4,
  layout = "kk"
)
}
\arguments{
\item{cc_df}{A dataframe with columns 'source', 'target', 'ligand', 'receptor' and 'score'. See \code{toy_data} for example.}

\item{colours}{A vector of colours for each cell type. Default is \code{paletteMartin()}, a colourblind-friendly palette.}

\item{option}{Either 'A' or 'B'. Option A will plot the number of interactions between pairs of cell types, option B will plot the top \code{n_top_ints} interactions and their scores.}

\item{n_top_ints}{The number of top interactions to plot. Only required for option B.}

\item{node_size}{Point size for nodes in option B.}

\item{label_size}{Size for labels in option B.}

\item{layout}{Algorithm for determining layout in option B. One of 'dh', 'drl', 'fr', 'gem', 'graphopt', 'kk', 'lgl', 'mds', 'nicely'. See iGraph layouts for more details.}
}
\value{
Returns a plot generated with the ggplot2 package
}
\description{
This function plots a network of representing the number of interactions between cell types
}
\examples{
data(toy_data, package = 'CCPlotR')
cc_network(toy_data)
cc_network(toy_data, colours = c("orange", "cornflowerblue", "hotpink"), option = "B")
}
